            function toggleTOC() {
               if (localStorage.tocVisible == "false") {
                   document.querySelector('nav').setAttribute('aria-hidden', false);
                   document.getElementById("toc-entries").style.width = "250px";
                   document.getElementById("main").style.marginLeft = "250px";
                   localStorage.tocVisible = "true";

               } else {                   
                   document.querySelector('nav').setAttribute('aria-hidden', true);
                   document.getElementById("toc-entries").style.width = "0";
                   document.getElementById("main").style.marginLeft = "0";
                   localStorage.tocVisible = "false";
               }
            }

            var activeEntryID = '';

            function calculateCollapsibleHeights() {
                var allHeights = 0;
                
                var contents = document.getElementsByClassName("toc-content");
                var j, h;

                for (j = 0; j < contents.length; j++) {
                  h = contents[j].scrollHeight;
                  allHeights += h;
                }
                
                var coll = document.getElementsByClassName("toc-collapsible");
                var i;

                for (i = 0; i < coll.length; i++) {
                    coll[i].addEventListener("click", function() {
                      this.classList.toggle("expanded");
                      var content = this.nextElementSibling;
                      if (content.style.maxHeight == allHeights + "px"){
                        content.style.maxHeight = "0px";
                      } else {
                        content.style.maxHeight = allHeights + "px";
                      }
                  });
                }
            }

            function numberAllTOCEntries() {
                var tocElements = document.querySelectorAll('.toc-link');
                // Set their ids
                for (var i = 0; i < tocElements.length; i++) {
                    var entry = tocElements[i];
                    entry.id = 'toc-' + i;
                    entry.classList.toggle("inactive"); // all start inactive
                    entry.addEventListener("click", function() {
                        if (activeEntryID != this.id) {
                            if (activeEntryID.startsWith('toc-')) {
                                var activeEntry = document.getElementById(activeEntryID);
                                activeEntry.classList.toggle("active");
                                activeEntry.classList.toggle("inactive");
                            }
                            activeEntryID = this.id;
                            this.classList.toggle("inactive");
                            this.classList.toggle("active");
                            
                        }
                    });
                }
            }

            function injectTOCOnClicks() {
                var elements = document.getElementsByTagName('span');
                for(var i = 0, len = elements.length; i < len; i++) {
                    var element = elements[i];
                    element.onclick = function () {
                        var content = '<object width="100%" height="100%" id="helpcontent" data="' + this.getAttribute("content") + '"/>';

                        const output = document.getElementById("main");
                        
                        var d = document.getElementById('placeholder');
                        d.innerHTML = content;
                        output.innerHTML = d.innerHTML;
                    }
                }
            }

            function configureTOC() {
                numberAllTOCEntries();
                calculateCollapsibleHeights();
                injectTOCOnClicks();
            }

            setTimeout(() => {
                localStorage.tocVisible = "false";
                 window.HelpViewer.showTOCButton(true, toggleTOC, toggleTOC);
                  window.HelpViewer.setTOCButton(true);
                configureTOC();
            }, 250);
